
/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Secure RO Handling ATP Test source file
*
* Filename:                     ODRM_SecROHandling_JoinDomain_ATP.h 
*
* 
* Created:                      17.03.2009
*
*
* \Author                      Shelly Lerman
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _ODRM_SEC_RO_HANDLING_JOIN_DOMAIN_ATP_H_
#define _ODRM_SEC_RO_HANDLING_JOIN_DOMAIN_ATP_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/


#ifdef __cplusplus
extern "C"
{
#endif


  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_SEC_RO_JoinDomainProcess
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * TEST DESCRIPTION:
  *  Test Join-Domain Process in Secure License Handling 
  *
  * Algorithm:
  * 1.Get workspace size. 
  * 2.Create key ring and initialize it with device private key
  * 3.Call to  TLK_ODRM_ProcessRegistration() API for RI Issuer registration
  * 4.Call to TLK_ODRM_ProcessJoinDomain() API 
  * 5.Verify that usage flag indicate that domain key was produced by TLK_ODRM_ProcessJoinDomain()  function 
  * 6.Call to TLK_ODRM_VerifyDomainRoBeforeInstall() API with Domain key from step 4.
  * 7.Activate content license using  TLK_ODRM_RetrieveKey() with KMAC and KREK keys from step 4 and secure clock descriptor from step 3.
  * 8.Validate that  this is correct RO key.
  *   8.1  Encrypt Plain text with the activated RO key from    TLK_ODRM_RetrieveKey().
  *   8.2 compare it to the Encrypted plain text with the 
  *       original RO key.
  *******************************************************************************/   
   DxError_t TST_ATP_SEC_RO_JoinDomainProcess(void);

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_SEC_RO_InvalidKeyInJoinDomain
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *   To test Join-Domain Process with Invalid Domain Key in Secure License Handling  
  *  
  * Algorithm: 
  * 1.Get workspace size. 
  * 2.Create key ring and initialize it with device private key
  * 3.Call to TLK_ODRM_ProcessJoinDomain() API with invalid Domain key in XML structure
  * 4.Verify that TLK_ODRM_RC_ERROR_CRYS error was returned
  *******************************************************************************/   
  DxError_t TST_ATP_SEC_RO_InvalidKeyInJoinDomain(void);

  /*****************************************************************************
  * Function Name:                                                           
  *  TST_ATP_SEC_RO_InvalidUsageFlagInJoinDomain
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  *  To test join-domain process in secure license handling, with invalid usage flag
  *  
  * Algorithm: 
  * 1.	Get workspace size. 
  * 2.	Create key ring and initialize it with device private key
  * 3.	Import a device private key with invalid usage flag.
  * 4.	Call to TLK_ODRM_ProcessJoinDomain() API .
  * 5.	Verify that TLK_ODRM_RC_ERROR_INCORRECT_KEY_PERMISSIONS error was returned
  *******************************************************************************/   
  DxError_t TST_ATP_SEC_RO_InvalidUsageFlagInJoinDomain(void);

#ifdef __cplusplus
}
#endif

#endif
